clear
close all
clc

addpath('Dati_modello')% inserito percorso di funzioni utilizzate.
addpath('Wind resource assessment')% inserito percorso di funzioni utilizzate.
% parametri per il solutore
prompt = 'write turbine name: ';

nometurb = input(prompt,'s');
if strcmp(nometurb,'tud6000') == 1
    load('TUDelft-6MW-turbine.mat')
    load('TUDelft-6MW-AeroData.mat')
elseif strcmp(nometurb,'u200') == 1
    load('Uppsala-200kW-turbine.mat')
    load('Uppsala-200kW-AeroData.mat')
else
    disp('wrong turbine name')
    return
end
[n1,n2,n3] = STL_reader(blades,nacelle,tower);

dt=0.05;
dx=pi/100;
dz = 0.1;
zvect = -0.5+dz/2:dz:0.5-dz/2;

%% DATI DI LOOKUP TABLES
%% Dati turbina specifica
Vnom = nominal.Vnom;
% tend=zeros(size(dtv));
dens = 1.225;
JJ = ctrl.JJ;% guessed inertia
th = 0;
ravg = mean(blades.radius);
np = 3;
Vcutin = 4;
Vcost = (1:1:25)';
%% VARIABILI DI CONTROLLO (MEDIE SU RIVOLUZIONE).
[Control_laws,wnom,Pnom] = control_values(Vcost,Vnom,Vcutin,...
    ravg,Tavg.T(:,:,1),Tavg.w);
ktr = wnom/Vnom;
%%SCELTA GEOMETRIA DI TURBINA
plot(Control_laws.w1,Control_laws.T1)
grid on
box on
xlabel('omega(rad/s)');
ylabel('Generator torque(Nm)');
title('Torque Control law');
tend = 1200;

%% Inserimento velocità del vento, scelta se costante o turbolento.
prompt = 'write chosen windspeed: ';

yy = input(prompt);
prompt = 'choose constant or turbulent wind (write 0/1): ';

flag = input(prompt);
yy = round(yy);
if strcmp(nometurb,'tud6000') == 1
    VSIM = load(strcat('Wind resource assessment\z100m\prova',num2str(yy),'.mat'));
elseif strcmp(nometurb,'u200') == 1
    VSIM = load(strcat('Wind resource assessment\z10m\prova',num2str(yy),'.mat'));
end
ttt = VSIM.Wind.t';
tt = min(ttt(end),tend);
VIN = max(VSIM.Wind.v,0);
VV = min(yy,Vnom);
WIND = timeseries(VIN,ttt);
figure(2)
plot(0:dt:tt,VIN(1:tt/dt+1))
xlabel('time(s)')
ylabel('windspeed(m/s)')
mv = mean(VIN(1:tt/dt+1));
tic
SIMULAZ = sim('ONSHORE_VAWT_MULTIUSE.slx');
tempo = toc;
Tgen = SIMULAZ.get('TGenerator');
Torque = Tgen.Data;
genavg = mean(Torque(3001:end));
w = SIMULAZ.get('rotspeed');
wrot = w.Data;
wavg = mean(wrot(3001:end));
Tw = SIMULAZ.get('Tblades');
Twind = Tw.Data;
windavg = mean(Twind(3001:end));
pitchs = SIMULAZ.get('collectivepitch');
pitchv = pitchs.Data;
pitchavg = mean(pitchv(3001:end));
Tend=Torque(end);
Power=Torque.*wrot;
Energy_wind = dt*trapz(Power);
Pavg = mean(Power);
Cp = Power./(mv.^3*1.225*ravg*blades.length(end));
figure(3)
plot(0:dt:tt,Power);
xlabel('time(s)');
ylabel('Power(W)');
grid on
box on
legend(strcat(num2str(yy),' m/s'));
title('P=P(t)')
xlim([0 1200])
hold on

figure(4)
plot(0:dt:tt,pitchv*180/pi);
xlabel('time(s)');
ylabel('Pitch angle(deg)');
grid on
box on
%     legend('Pitch angle');
title(strcat('pitch angle with wind = ',num2str(yy),'m/s at hub height'))
hold on

rmpath('Dati_modello')
rmpath('Wind resource assessment')